//*********************************************************************************
// SMaker.cpp - SpriteMaker classes
//
// Half-Life Sprite Maker - Written by David Flor, (c) 1999 Mach III Enterprises
//*********************************************************************************

#include "stdafx.h"
#include "sprmake.h"
#include <math.h>

TBMPData::TBMPData(bitmap_struct *_bData)
{
	Clear();
	bData = *_bData;
	fData.width = bData.bmih.biWidth;
	fData.origin[0] = -(fData.width / 2);
	fData.height = bData.bmih.biHeight;
	fData.origin[1] = -(fData.height / 2);
}

void TBMPData::Clear(void)
{
	memset(&bData, 0, sizeof(bData));
	memset(&fData, 0, sizeof(fData));
	next = NULL;
}

void TBMPData::Dispose(void)
{
	if (bData.ppbBits)
		free(bData.ppbBits);
	if (bData.ppbPalette)
		free(bData.ppbPalette);
	if (next)
		delete next;
	Clear();
}

void TBMPArray::Clear(void)
{
	bmpData = NULL;
	
	memset(&spriteData, 0, sizeof(spriteData));
	spriteData.ident = IDSPRITEHEADER;
	spriteData.version = SPRITE_VERSION;
	spriteData.texFormat = gTransparencyMode;
	spriteData.synctype = ST_RAND;
}

void TBMPArray::Dispose(void)
{
	if (bmpData)
		delete bmpData;

	Clear();
};

void TBMPArray::AddBMPData(bitmap_struct *bData)
{
	TBMPData	*theBMP, *tPos;

	theBMP = new TBMPData(bData);
	if (theBMP)
	{
		long tX, tY;

		if (!bmpData)
			bmpData = theBMP;
		else
		{
			tPos = bmpData;
			while (tPos->next)
				tPos = tPos->next;
			tPos->next = theBMP;
		}

		tX = spriteData.width = max(spriteData.width, bData->bmih.biWidth);
		tX /= 2;
		tY = spriteData.height = max(spriteData.height, bData->bmih.biHeight);
		tY /= 2;
		spriteData.boundingradius = (float)sqrt((double)(tX * tX) + (double)(tY * tY));
		spriteData.numframes++;
	}
}
